// deklaracja warstwy zawierającej znaczniki (markery)
var layerMarkers;

// utwórz warstwę na przyjęcie znaczników (markerów)
function createMarkersLayer(id, layerName, displayInLayerSwitcher, setVisibility){
	layerMarkers = new OpenLayers.Layer.Markers(layerName);
	// przypisz identyfikator warstwy
	layerMarkers.id = id;
	// pokaż warstwę w oknie przełącznika warstw 
	layerMarkers.displayInLayerSwitcher = displayInLayerSwitcher;
	// pokaż warstwę na mapie 
	layerMarkers.setVisibility(setVisibility);
}

// funkcja tworząca  w warstwie znaczników 'layerMarkers' pojedyncze znaczniki (markery) 
// o atrybutach określonych w argumentach funkcji 
function createMarkers(id, lon, lat, markerFile, markerWidth, markerHeight, offsetX, offsetY) {
	// konwertuj współrzędne geograficzne z układu odniesienia EPSG:4326 na EPSG:900913,
	var lonLat = new OpenLayers.LonLat(lon, lat).transform(epsg4326, epsg900913);
	// utwórz reprezentuję pary szerokość / wysokość
	var size = new OpenLayers.Size(markerWidth, markerHeight);
	// oblicz przesunięcie markera
	var offset = new OpenLayers.Pixel(offsetX, offsetY);
	// utwórz grafikę w oparciu o adres URL, o rozmiarze (size)
	// i przesunięciu punktu środkowego (offset))
	var icon = new OpenLayers.Icon(markerFile,size, offset);

	// utwórz klasę feature na podstawie danych geograficznych i graficznych
	var feature = new OpenLayers.Feature(layerMarkers, lonLat, {'icon': icon});

	// utwórz obiekt znacznika
	var marker = feature.createMarker();
	marker.id = id;
	// dodaj znacznik (marker) do warstwy 'layerMarkers'
	layerMarkers.addMarker(marker);
}

function fDrawMarkers(){
	// współrzędne punktu
	var lon; var lat;
	// wielkość pliku graficznego i zarazem podkatalog plików graficznych
	var size=48;
	// ścieżka do plików graficznych "Centered")
	var path='markers/IconsLand/PNG/Centered/'+size.toString()+'x'+size.toString()+'/';

	// utwórz warstwę na przyjęcie znaczników (markerów)
	createMarkersLayer("markers", "Znaczniki i ślad", true, true)

	// tworzenie poszczególnych punktów graficznych w warstwie wektorowej 'layerMarkers'
	lat="51.288912026211619";lon="22.496877992525697"
	createMarkers('mk_01',lon,lat,path+'MapMarker_Ball__Azure.png',size,size,-size/2,-size);
	lat="51.289822971448302";lon="22.501583006232977"
	createMarkers('mk_02',lon,lat,path+'MapMarker_Ball_Left_Chartreuse.png',size,size,-size/2,-size);
	lat="51.289219977334142";lon="22.503895992413163"
	createMarkers('mk_03',lon,lat,path+'MapMarker_Ball_Right_Pink.png',size,size,-size/2,-size);
	lat="51.288394024595618"; lon="22.505702963098884"
	createMarkers('mk_04',lon,lat,path+'MapMarker_Board_Pink.png',size,size,-size/2,-size);
	lat="51.290338039398193"; lon="22.506549032405019"
	createMarkers('mk_05',lon,lat,path+'MapMarker_Bubble_Chartreuse.png',size,size,-size/2,-size);
	lat="51.2920300103724"; lon="22.505863979458809"
	createMarkers('mk_06',lon,lat,path+'MapMarker_DrawingPin_Left_Azure.png',size,size,-size/2,-size);
	lat="51.293702032417059"; lon="22.505411021411419"
	createMarkers('mk_07',lon,lat,path+'MapMarker_DrawingPin_Right_Pink.png',size,size,-size/2,-size);
	lat="51.295340023934841"; lon="22.504996033385396"
	createMarkers('mk_08',lon,lat,path+'MapMarker_Flag2_Left_Chartreuse.png',size,size,-size/2,-size);
	lat="51.297403983771801"; lon="22.504101013764739"
	createMarkers('mk_09',lon,lat,path+'MapMarker_Flag5_Pink.png',size,size,-size/2,-size);
	lat="51.299123028293252"; lon="22.503597009927034"
	createMarkers('mk_10',lon,lat,path+'MapMarker_Marker_Inside_Chartreuse.png',size,size,-size/2,-size);
	lat="51.300733024254441"; lon="22.503075990825891"
	createMarkers('mk_11',lon,lat,path+'MapMarker_Marker_Outside_Pink.png',size,size,-size/2,-size);
	lat="51.302910977974534"; lon="22.502304017543793"
	createMarkers('mk_12',lon,lat,path+'MapMarker_PushPin1__Azure.png',size,size,-size/2,-size);
	lat="51.305026989430189"; lon="22.501572025939822"
	createMarkers('mk_13',lon,lat,path+'MapMarker_PushPin2__Pink.png',size,size,-size/2,-size);
	lat="51.306459037587047"; lon="22.501102974638343"
	createMarkers('mk_14',lon,lat,path+'MapMarker_PushPin2_Left_Chartreuse.png',size,size,-size/2,-size);
	lat="51.307248026132584"; lon="22.498928960412741"
	createMarkers('mk_15',lon,lat,path+'MapMarker_PushPin2_Right_Azure.png',size,size,-size/2,-size);
	lat="51.307167978957295"; lon="22.495145034044981"
	createMarkers('mk_16',lon,lat,path+'MapMarker_Flag2_Right_Pink.png',size,size,-size/2,-size);
	lat="51.307268980890512"; lon="22.491870978847146"
	createMarkers('mk_17',lon,lat,path+'MapMarker_Flag4_Left_Azure.png',size,size,-size/2,-size);
	lat="51.305890996009111"; lon="22.490770015865564"
	createMarkers('mk_18',lon,lat,path+'MapMarker_Flag4_Right_Chartreuse.png',size,size,-size/2,-size);

	// ścieżka do plików graficznych "NotCentered")
	path='markers/IconsLand/PNG/NotCentered/'+size.toString()+'x'+size.toString()+'/';

	lat="51.303506009280682"; lon="22.491532014682889"
	createMarkers('mk_19',lon,lat,path+'MapMarker_ChequeredFlag_Left_Azure.png',size,size,-size,-size);	
	lat="51.301445988938212"; lon="22.49222201295197"
	createMarkers('mk_20',lon,lat,path+'MapMarker_ChequeredFlag_Right_Pink.png',size,size,0,-size);	
	lat="51.29940097220242"; lon="22.492963979020715"
	createMarkers('mk_21',lon,lat,path+'MapMarker_Flag1_Left_Chartreuse.png',size,size,-size/2,-size);
	lat="51.297383029013872"; lon="22.493559010326862"
	createMarkers('mk_22',lon,lat,path+'MapMarker_Flag1_Right_Pink.png',size,size,-size/4,-size);
	lat="51.295751994475722"; lon="22.494112970307469"
	createMarkers('mk_23',lon,lat,path+'MapMarker_Flag3_Left_Chartreuse.png',size,size,-size,-size);
	lat="51.294504012912512"; lon="22.494491999968886"
	createMarkers('mk_24',lon,lat,path+'MapMarker_Flag3_Right_Azure.png',size,size,0,-size);
	lat="51.28710899502039"; lon="22.500583967193961"
	createMarkers('mk_25',lon,lat,path+'MapMarker_PushPin1_Left_Chartreuse.png',size,size,-size/2,-size);
	lat="51.28674304112792"; lon="22.498324038460851"
	createMarkers('mk_26',lon,lat,path+'MapMarker_PushPin1_Right_Pink.png',size,size,-size/4,-size);

	// dodaj warstwę 'layerMarkers' do instancji mapy
	map.addLayer(layerMarkers);
}
