// deklaracja warstwy wektorowej zawierającej graficzne punkty 'myGraphicPoint'
var vectorGraphicLayer;
var myGraphicPoint;

function fDrawExternalGraphic(id, nameLayer){
	// współrzędne punktu
	var lon; var lat;
	// wielkość pliku graficznego i zarazem podkatalog plików graficznych (tutaj tylko 48)
	var size=48;
	// ścieżka do plików graficznych "Centered")
	var path='markers/IconsLand/PNG/Centered/'+size.toString()+'x'+size.toString()+'/';

	// utwórz warstwę wektorową
	createGraphicLayer(id, nameLayer)

	// tworzenie poszczególnych punktów graficznych w warstwie wektorowej 'vectorGraphicLayer'
	lat="51.288912026211619";lon="22.496877992525697"
	createGraphicPoint(lon,lat,path+'MapMarker_Ball__Azure.png', size, size, -size/2, -size);
	lat="51.289822971448302";lon="22.501583006232977"
	createGraphicPoint(lon,lat,path+'MapMarker_Ball_Left_Chartreuse.png', size, size, -size/2, -size);
	lat="51.289219977334142";lon="22.503895992413163"
	createGraphicPoint(lon,lat,path+'MapMarker_Ball_Right_Pink.png', size, size, -size/2, -size);
	lat="51.288394024595618"; lon="22.505702963098884"
	createGraphicPoint(lon,lat,path+'MapMarker_Board_Pink.png', size, size, -size/2, -size);
	lat="51.290338039398193"; lon="22.506549032405019"
	createGraphicPoint(lon,lat,path+'MapMarker_Bubble_Chartreuse.png', size, size, -size/2, -size);
	lat="51.2920300103724"; lon="22.505863979458809"
	createGraphicPoint(lon,lat,path+'MapMarker_DrawingPin_Left_Azure.png', size, size, -size/2, -size);
	lat="51.293702032417059"; lon="22.505411021411419"
	createGraphicPoint(lon,lat,path+'MapMarker_DrawingPin_Right_Pink.png', size, size, -size/2, -size);
	lat="51.295340023934841"; lon="22.504996033385396"
	createGraphicPoint(lon,lat,path+'MapMarker_Flag2_Left_Chartreuse.png', size, size, -size/2, -size);
	lat="51.297403983771801"; lon="22.504101013764739"
	createGraphicPoint(lon,lat,path+'MapMarker_Flag5_Pink.png', size, size, -size/2, -size);
	lat="51.299123028293252"; lon="22.503597009927034"
	createGraphicPoint(lon,lat,path+'MapMarker_Marker_Inside_Chartreuse.png', size, size, -size/2, -size);
	lat="51.300733024254441"; lon="22.503075990825891"
	createGraphicPoint(lon,lat,path+'MapMarker_Marker_Outside_Pink.png', size, size, -size/2, -size);
	lat="51.302910977974534"; lon="22.502304017543793"
	createGraphicPoint(lon,lat,path+'MapMarker_PushPin1__Azure.png', size, size, -size/2, -size);
	lat="51.305026989430189"; lon="22.501572025939822"
	createGraphicPoint(lon,lat,path+'MapMarker_PushPin2__Pink.png', size, size, -size/2, -size);
	lat="51.306459037587047"; lon="22.501102974638343"
	createGraphicPoint(lon,lat,path+'MapMarker_PushPin2_Left_Chartreuse.png', size, size, -size/2, -size);
	lat="51.307248026132584"; lon="22.498928960412741"
	createGraphicPoint(lon,lat,path+'MapMarker_PushPin2_Right_Azure.png', size, size, -size/2, -size);
	lat="51.307167978957295"; lon="22.495145034044981"
	createGraphicPoint(lon,lat,path+'MapMarker_Flag2_Right_Pink.png', size, size, -size/2, -size);
	lat="51.307268980890512"; lon="22.491870978847146"
	createGraphicPoint(lon,lat,path+'MapMarker_Flag4_Left_Azure.png', size, size, -size/2, -size);
	lat="51.305890996009111"; lon="22.490770015865564"
	createGraphicPoint(lon,lat,path+'MapMarker_Flag4_Right_Chartreuse.png', size, size, -size/2, -size);

	// ścieżka do plików graficznych "NotCentered")
	path='markers/IconsLand/PNG/NotCentered/'+size.toString()+'x'+size.toString()+'/';

	lat="51.303506009280682"; lon="22.491532014682889"
	createGraphicPoint(lon,lat,path+'MapMarker_ChequeredFlag_Left_Azure.png', size, size, -size, -size);	
	lat="51.301445988938212"; lon="22.49222201295197"
	createGraphicPoint(lon,lat,path+'MapMarker_ChequeredFlag_Right_Pink.png', size, size, 0, -size);	
	lat="51.29940097220242"; lon="22.492963979020715"
	createGraphicPoint(lon,lat,path+'MapMarker_Flag1_Left_Chartreuse.png', size, size, -size/2, -size);
	lat="51.297383029013872"; lon="22.493559010326862"
	createGraphicPoint(lon,lat,path+'MapMarker_Flag1_Right_Pink.png', size, size, -size/4, -size);
	lat="51.295751994475722"; lon="22.494112970307469"
	createGraphicPoint(lon,lat,path+'MapMarker_Flag3_Left_Chartreuse.png', size, size, -size, -size);
	lat="51.294504012912512"; lon="22.494491999968886"
	createGraphicPoint(lon,lat,path+'MapMarker_Flag3_Right_Azure.png', size, size, 0, -size);
	lat="51.28710899502039"; lon="22.500583967193961"
	createGraphicPoint(lon,lat,path+'MapMarker_PushPin1_Left_Chartreuse.png', size, size, -size/2, -size);
	lat="51.28674304112792"; lon="22.498324038460851"
	createGraphicPoint(lon,lat,path+'MapMarker_PushPin1_Right_Pink.png', size, size, -size/4, -size);

	// dodaj warstwę 'vectorGraphicLayer' do obiektu 'map'
	map.addLayer(vectorGraphicLayer);
}

// utwórz warstwę wektorową na przyjęcie graficznych punktów
function createGraphicLayer(id, nameLayer){
	vectorGraphicLayer = new OpenLayers.Layer.Vector(nameLayer);
	// przypisz identyfikator warstwy
	vectorGraphicLayer.id = id;
	// pokaż warstwę w oknie przełącznika warstw 
	vectorGraphicLayer.displayInLayerSwitcher = true;
	// pokaż warstwę na mapie 
	vectorGraphicLayer.setVisibility(true)
}

// funkcja tworząca pojedyncze punkty graficzne w warstwie wektorowej 'vectorGraphicLayer' 
// o atrybutach określonych w argumentach funkcji 
function createGraphicPoint(lon, lat, externalGraphic, graphicWidth, graphicHeight, 
														graphicXOffset, graphicYOffset) {
	var point = new OpenLayers.Geometry.Point(lon, lat).transform(epsg4326, epsg900913);
	myGraphicPoint = new OpenLayers.Feature.Vector(point, {},
					{'externalGraphic': externalGraphic,
					'graphicHeight': graphicHeight,
					'graphicWidth': graphicWidth,
					'graphicXOffset':graphicXOffset,
					'graphicYOffset':graphicYOffset
					//rotation: pointRotation	>= MS ACCESS przy rotacji externalGraphic dodaje
					//brzydką obwódkę i cienie, ucina grafikę oraz nie wyświetla okno typu framedCloud
					}
			);
	vectorGraphicLayer.addFeatures(myGraphicPoint);
}
