// deklaracja warstwy wektorowej zawierającej punkty 'myPoint'
var vectorPointsLayer;
var myPoint;
 
// mniej istotne (domyślne) atrybuty punktu 
var stylePoint = {
		'strokeOpacity': 0.75,
		'fillOpacity':0.90,
		'strokeDashstyle':'solid'
};
 
// mniej istotne (domyślne) atrybuty etykiety przypisanej do punktu
var styleLabel={
		'fontColor':'#800',
		'fontOpacity':0.7,
		'fontFamily':'',
		'fontSize':'1em',
		'fontStyle':'italic',
		'fontWeight':'bold'
}

// utwórz domyślny styl punktu,
// zapis 'atrybut': '${nazwaAtrybutu}' oznacza, że można dla każdego punktu
// zmieniać wartość atrybutu przypisując mu wartość przekazaną w argumentach funkcji
var stylePointDefault =new OpenLayers.Style({
		'label': '${label}',
		'labelAlign':'${labelAlign}',
		'labelXOffset':'${labelXOffset}',
		'labelYOffset':'${labelYOffset}',
		'strokeColor': '${strokeColor}',
		'strokeOpacity': stylePoint['strokeOpacity'],
		'strokeWidth': '${strokeWidth}',
		'strokeDashstyle':stylePoint['strokeDashstyle'],
		'fillColor': '${fillColor}',
		'fillOpacity':stylePoint['fillOpacity'],
		'pointRadius': '${pointRadius}',
		'graphicName': '${graphicName}',
		'rotation': '${rotation}',
		'fontColor':styleLabel['fontColor'],
		'fontOpacity':styleLabel['fontOpacity'],
		'fontFamily':styleLabel['fontFamily'],
		'fontSize':styleLabel['fontSize'],
		'fontStyle':styleLabel['fontStyle'],
		'fontWeight':styleLabel['fontWeight']
});

// własne punkty znalezione w internecie
OpenLayers.Renderer.symbol.lightning = [0,0,4,2,6,0,10,5,6,3,4,5,0,0];
OpenLayers.Renderer.symbol.rectangle = [0,0,4,0,4,10,0,10,0,0];
OpenLayers.Renderer.symbol.church = [4,0,6,0,6,4,10,4,10,6,6,6,6,14,4,14,4,6,0,6,0,4,4,4,4,0];
OpenLayers.Renderer.symbol.flag = [0,0,0,140,120,140,120,60,4,60,4,0,0,0];
OpenLayers.Renderer.symbol.arrow = [0,2,1,0,2,2,1,0,0,2];
OpenLayers.Renderer.symbol.pointToIcon = [100,70,20,50,42,70,20,90];
OpenLayers.Renderer.symbol.boatright = [45,0,35,10,0,10,0,0,25,0,25,-55,0,-10,25,-10,25,-55,
																				45,-2,25,-5,25,0,45,0];
OpenLayers.Renderer.symbol.ship = [-4,0,-3,-6,0,-14,3,-6,4,0,4,7,3,11,2,14,-2,14,-3,11,-4,7,-4,0];
// moje własne punkty
OpenLayers.Renderer.symbol.flagLeft = [0,0,0,-140,-120,-140,-120,-60,-4,-60,-4,0,0,0];
OpenLayers.Renderer.symbol.flagRight = [0,0,0,-140,120,-140,120,-60,4,-60,4,0,0,0];
OpenLayers.Renderer.symbol.pennantRight = [0,0,0,-140,120,-100,120,-100,120,-60,4,-60,4,0,0,0];
OpenLayers.Renderer.symbol.pennantLeft = [0,0,0,-140,-120,-100,-120,-100,-120,-60,-4,-60,-4,0,0,0];

function fDrawPoints(id, nameLayer){
// utwórz warstwę wektorową o domyślnym stylu punktów 'stylePointDefault'
createPointsLayer(id, nameLayer, true, true);

// tworzenie własnych punktów w warstwie wektorowej 'vectorPointsLayer'
createPoint(22.47000,51.284000,'lightning','lm',20,-10,15,0,'#f0f',2,'#00f','lightning');
createPoint(22.47500,51.286000,'rectangle','lm',20,-10,15,0,'#800',2,'#0f0','rectangle');
createPoint(22.48000,51.288000,'church','lm',20,-10,15,0,'#008',2,'#f00','church');
createPoint(22.48500,51.290000,'flag','lm',20,-10,15,0,'#800',2,'#0ff','flag');
createPoint(22.49000,51.292000,'arrow','lm',20,-10,10,0,'#088',2,'#ff0','arrow');
createPoint(22.49500,51.294000,'pointToIcon','lm',20,-10,15,0,'#008',2,'#f0f','pointToIcon');
createPoint(22.50000,51.296000,'boatright','lm',20,-10,15,0,'#f00',2,'#080','boatright');
createPoint(22.50500,51.298000,'ship','lm',20,-10,15,0,'#800',2,'#088','ship');
createPoint(22.51020,51.300000,'flagLeft','lm',20,-10,15,0,'#00f',2,'#808','flagLeft');
createPoint(22.51540,51.302000,'flagRight','lm',20,-10,15,0,'#0f0',2,'#00f','flagRight');
createPoint(22.52060,51.304000,'pennantLeft','lm',20,-10,15,0,'#00f',2,'#080','pennantLeft');
createPoint(22.52580,51.306000,'pennantRight','lm',20,-10,15,0,'#00f',2,'#c00','pennantRight');

// dodaj warstwę 'vectorPointsLayer' do obiektu 'map'
map.addLayer(vectorPointsLayer);

}

// utwórz warstwę wektorową na przyjęcie punktów o domyślnym stylu punktów 'stylePointDefault'
function createPointsLayer(id, nameLayer, displayInLayerSwitcher, setVisibility){
	vectorPointsLayer = new OpenLayers.Layer.Vector(nameLayer, {
								styleMap: new OpenLayers.StyleMap({
													'default': stylePointDefault}) 
	});
	// przypisz identyfikator warstwy
	vectorPointsLayer.id = id;
	// pokaż warstwę w oknie przełącznika warstw 
	vectorPointsLayer.displayInLayerSwitcher = displayInLayerSwitcher;
	// pokaż warstwę na mapie 
	vectorPointsLayer.setVisibility(setVisibility);
}

// funkcja tworząca pojedyncze punkty  w warstwie wektorowej 'vectorPointsLayer' 
// o atrybutach określonych w argumentach funkcji 
function createPoint(lon, lat, label, labelAlign, labelXOffset, labelYOffset, pointRadius,
										 rotation, strokeColor, strokeWidth, fillColor, graphicName){
	var point = new OpenLayers.Geometry.Point(lon, lat).transform(epsg4326, epsg900913);
	myPoint = new OpenLayers.Feature.Vector(point);
	myPoint.attributes={
									'label': label,
									'labelAlign':labelAlign,
									'labelXOffset':labelXOffset,
									'labelYOffset':labelYOffset,
									'pointRadius':pointRadius,
									'rotation':rotation,
									'strokeColor':strokeColor,
									'strokeWidth':strokeWidth,
									'fillColor':fillColor,
									'graphicName':graphicName
									};
	// dodaj punkt do warstwy 'vectorPointsLayer'
	vectorPointsLayer.addFeatures(myPoint);
}
