// deklaracja warstwy wektorowej zawierającej punkty 'myPoint'
var vectorPointsLayer;
var myPoint;
 
// mniej istotne (domyślne) atrybuty punktu 
var stylePoint = {
		'strokeOpacity': 0.75,
		'fillOpacity':0.90,
		'strokeDashstyle':'solid'
};
 
// mniej istotne (domyślne) atrybuty etykiety przypisanej do punktu
var styleLabel={
		'fontColor':'#800',
		'fontOpacity':0.7,
		'fontFamily':'',
		'fontSize':'1em',
		'fontStyle':'italic',
		'fontWeight':'bold'
}

// utwórz domyślny styl punktu,
// zapis 'atrybut': '${nazwaAtrybutu}' oznacza, że można dla każdego punktu
// zmieniać wartość atrybutu przypisując mu wartość przekazaną w argumentach funkcji
var stylePointDefault =new OpenLayers.Style({
		'label': '${label}',
		'labelAlign':'${labelAlign}',
		'labelXOffset':'${labelXOffset}',
		'labelYOffset':'${labelYOffset}',
		'strokeColor': '${strokeColor}',
		'strokeOpacity': stylePoint['strokeOpacity'],
		'strokeWidth': '${strokeWidth}',
		'strokeDashstyle':stylePoint['strokeDashstyle'],
		'fillColor': '${fillColor}',
		'fillOpacity':stylePoint['fillOpacity'],
		'pointRadius': '${pointRadius}',
		'graphicName': '${graphicName}',
		'rotation': '${rotation}',
		'fontColor':styleLabel['fontColor'],
		'fontOpacity':styleLabel['fontOpacity'],
		'fontFamily':styleLabel['fontFamily'],
		'fontSize':styleLabel['fontSize'],
		'fontStyle':styleLabel['fontStyle'],
		'fontWeight':styleLabel['fontWeight']
});


function fDrawPoints(id, nameLayer){
	// utwórz warstwę wektorową o domyślnym stylu punktów 'stylePointDefault'
	createPointsLayer(id, nameLayer,true, true);

	// tworzenie poszczególnych punktów w warstwie wektorowej 'vectorPointsLayer'
	createPoint(22.50059,51.287121,'<= Start','lm',10,-3,6,17,'#000',2,'#ff0','triangle');
	createPoint(22.50610,51.2921,'Cmentarz wojenny, \n kapliczka, \n krzyż',
					'lm',15,0,12,0,'#000',2,'#f00','star');
	createPoint(22.50503,51.29536,'Sklep','lm',12,0,5,0,'#080',2,'#f00','square');
	createPoint(22.50423,51.29688,'Krzyż','rm',-12,0,10,0,'#f0f',2,'#088','cross');
	createPoint(22.50310,51.30102,'Wysypisko','lm',12,0,10,0,'#f0f',2,'#080','circle');
	createPoint(22.50162,51.30518,'Krzyż','lm',12,0,10,0,'#f00',2,'#088','triangle');
	createPoint(22.49047,51.30705,'Krzyż','rm',-8,-10,10,0,'#f0f',2,'#080','star');
	createPoint(22.49197,51.30215,'Kapliczka','rm',-12,0,10,0,'#088',2,'#0f0','circle');
	createPoint(22.49300,51.29900,'Przystanek \n Snopków','lm',-65,0,10,0,'#f00',2,'#080','cross');
	createPoint(22.49544,51.29239,'Parking','lm',10,0,10,0,'#088',2,'#800','x');
	createPoint(22.49716,51.28763,'Dom Ojców Białych \n Misjonarzy Afryki w Lublinie',
																 'rm',-20,5,10,0,'#f0f',2,'#080','square');
	createPoint(22.49834,51.28675,'Koniec =>','lm',-55,0,6,0,'#f00',2,'#0ff','x');

	// dodaj warstwę 'vectorPointsLayer' do obiektu 'map'
	map.addLayer(vectorPointsLayer);
}

// utwórz warstwę wektorową na przyjęcie punktów o domyślnym stylu punktów 'stylePointDefault'
function createPointsLayer(id, nameLayer, displayInLayerSwitcher, setVisibility){
	vectorPointsLayer = new OpenLayers.Layer.Vector(nameLayer, {
								styleMap: new OpenLayers.StyleMap({
													'default': stylePointDefault}) 
	});
	// przypisz identyfikator warstwy
	vectorPointsLayer.id = id;
	// pokaż warstwę w oknie przełącznika warstw 
	vectorPointsLayer.displayInLayerSwitcher = displayInLayerSwitcher;
	// pokaż warstwę na mapie 
	vectorPointsLayer.setVisibility(setVisibility);
}

// funkcja tworząca pojedyncze punkty  w warstwie wektorowej 'vectorPointsLayer' 
// o atrybutach określonych w argumentach funkcji 
function createPoint(lon, lat, label, labelAlign, labelXOffset, labelYOffset, pointRadius,
										 rotation, strokeColor, strokeWidth, fillColor, graphicName){
	var point = new OpenLayers.Geometry.Point(lon, lat).transform(epsg4326, epsg900913);
	myPoint = new OpenLayers.Feature.Vector(point);
	myPoint.attributes={
									'label': label,
									'labelAlign':labelAlign,
									'labelXOffset':labelXOffset,
									'labelYOffset':labelYOffset,
									'pointRadius':pointRadius,
									'rotation':rotation,
									'strokeColor':strokeColor,
									'strokeWidth':strokeWidth,
									'fillColor':fillColor,
									'graphicName':graphicName
									};
	// dodaj punkt do warstwy 'vectorPointsLayer'
	vectorPointsLayer.addFeatures(myPoint);
}
